/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GConstants;
import g4p_controls.GConstantsInternal;
import g4p_controls.GWindow;
import java.util.Collections;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public final class GWindowImpl
implements GConstants,
GConstantsInternal {
    public LinkedList<GAbstractControl> windowControls = new LinkedList();
    public LinkedList<GAbstractControl> toRemove = new LinkedList();
    public LinkedList<GAbstractControl> toAdd = new LinkedList();
    PApplet app;
    PMatrix orgMatrix = null;
    int last_width;
    int last_height;
    boolean is3D = false;

    public GWindowImpl(PApplet pApplet) {
        this.app = pApplet;
        this.last_width = this.app.width;
        this.last_height = this.app.height;
        PMatrix pMatrix = pApplet.getMatrix();
        if (pMatrix instanceof PMatrix3D) {
            this.orgMatrix = pMatrix;
            this.is3D = true;
        }
        this.registerMethods();
    }

    public boolean usesGL() {
        return this.app.getGraphics().isGL();
    }

    public void registerMethods() {
        this.app.registerMethod("pre", (Object)this);
        this.app.registerMethod("draw", (Object)this);
        this.app.registerMethod("post", (Object)this);
        this.app.registerMethod("mouseEvent", (Object)this);
        this.app.registerMethod("keyEvent", (Object)this);
        this.app.registerMethod("dispose", (Object)this);
    }

    protected void unregisterMethods() {
        this.app.unregisterMethod("pre", (Object)this);
        this.app.unregisterMethod("draw", (Object)this);
        this.app.unregisterMethod("post", (Object)this);
        this.app.unregisterMethod("mouseEvent", (Object)this);
        this.app.unregisterMethod("keyEvent", (Object)this);
    }

    protected void addToWindow(GAbstractControl gAbstractControl) {
        if (!this.toAdd.contains(gAbstractControl) && !this.windowControls.contains(gAbstractControl)) {
            this.toAdd.add(gAbstractControl);
        }
    }

    protected void removeFromWindow(GAbstractControl gAbstractControl) {
        this.toRemove.add(gAbstractControl);
    }

    void invalidateBuffers() {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.bufferInvalid = true;
        }
    }

    void setColorScheme(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setLocalColorScheme(n);
        }
    }

    void setAlpha(int n) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            gAbstractControl.setAlpha(n);
        }
    }

    public void draw() {
        this.app.pushMatrix();
        if (this.orgMatrix != null) {
            this.app.setMatrix(this.orgMatrix);
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 1) != 1) continue;
            gAbstractControl.draw();
        }
        this.app.popMatrix();
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 2) != 2) continue;
            gAbstractControl.mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (!this.usesGL()) {
            this.sendKeyEvent(keyEvent);
            return;
        }
        KeyEvent keyEvent2 = keyEvent;
        char c = keyEvent.getKey();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getAction();
        Object object = keyEvent.getNative();
        long l = keyEvent.getMillis();
        int n3 = keyEvent.getModifiers();
        switch (n) {
            case 8: {
                c = '\b';
                break;
            }
            case 10: {
                c = '\n';
                break;
            }
            case 13: {
                c = '\r';
                break;
            }
            case 127: 
            case 147: {
                n = 127;
                c = '\u007f';
            }
        }
        if (n == 8 || n == 10 || n == 13 || n == 127) {
            switch (n2) {
                case 1: {
                    keyEvent2 = new KeyEvent(object, l, 1, n3, c, n);
                    this.sendKeyEvent(keyEvent2);
                    break;
                }
                case 2: {
                    keyEvent2 = new KeyEvent(null, l - 1L, 3, n3, c, n);
                    this.sendKeyEvent(keyEvent2);
                    keyEvent2 = new KeyEvent(object, l, 2, n3, c, n);
                    this.sendKeyEvent(keyEvent2);
                }
            }
        } else {
            this.sendKeyEvent(keyEvent);
        }
    }

    private void sendKeyEvent(KeyEvent keyEvent) {
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 8) != 8) continue;
            gAbstractControl.keyEvent(keyEvent);
        }
    }

    public void dispose() {
        for (GWindow gWindow : G4P.allWindows) {
            gWindow.forceClose();
        }
    }

    public void pre() {
        if (this.is3D && (this.last_width != this.app.width || this.last_height != this.app.height)) {
            this.last_width = this.app.width;
            this.last_height = this.app.height;
            this.orgMatrix = this.app.getMatrix();
        }
        if (GAbstractControl.controlToTakeFocus != null && GAbstractControl.controlToTakeFocus.getPApplet() == this.app) {
            GAbstractControl.controlToTakeFocus.setFocus(true);
            GAbstractControl.controlToTakeFocus = null;
        }
        for (GAbstractControl gAbstractControl : this.windowControls) {
            if ((gAbstractControl.registeredMethods & 4) != 4) continue;
            gAbstractControl.pre();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (G4P.cursorChangeEnabled) {
            if (GAbstractControl.cursorIsOver != null && GAbstractControl.cursorIsOver.getPApplet() == this.app) {
                this.app.cursor(GAbstractControl.cursorIsOver.cursorOver);
            } else {
                this.app.cursor(G4P.mouseOff);
            }
        }
        for (GAbstractControl iterator : this.windowControls) {
            if ((iterator.registeredMethods & 0x10) != 16) continue;
            iterator.post();
        }
        GWindowImpl gWindowImpl = this;
        synchronized (gWindowImpl) {
            if (!this.toRemove.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toRemove) {
                    if (GAbstractControl.focusIsWith == gAbstractControl) {
                        gAbstractControl.loseFocus(null);
                    }
                    gAbstractControl.buffer = null;
                    if (gAbstractControl.parent != null) {
                        gAbstractControl.parent.children.remove(gAbstractControl);
                        gAbstractControl.parent = null;
                    }
                    if (gAbstractControl.children != null) {
                        gAbstractControl.children.clear();
                    }
                    gAbstractControl.palette = null;
                    gAbstractControl.eventHandlerObject = null;
                    gAbstractControl.eventHandlerMethod = null;
                    gAbstractControl.winApp = null;
                    this.windowControls.remove(gAbstractControl);
                }
                this.toRemove.clear();
                System.gc();
            }
            if (!this.toAdd.isEmpty()) {
                for (GAbstractControl gAbstractControl : this.toAdd) {
                    this.windowControls.add(gAbstractControl);
                }
                this.toAdd.clear();
                Collections.sort(this.windowControls, G4P.zorder);
            }
        }
    }

    String actionString(MouseEvent mouseEvent) {
        switch (mouseEvent.getAction()) {
            default: {
                return "UNKNOWN";
            }
            case 3: {
                return "CLICK";
            }
            case 4: {
                return "DRAG";
            }
            case 6: {
                return "ENTER";
            }
            case 7: {
                return "EXIT";
            }
            case 5: {
                return "MOVE";
            }
            case 1: {
                return "PRESS";
            }
            case 2: {
                return "RELEASE";
            }
            case 8: 
        }
        return "WHEEL";
    }
}

