/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GEvent;
import g4p_controls.HotSpot;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GStick
extends GAbstractControl {
    protected static final int BORDERS = 0;
    protected static final int LED_INACTIVE = 1;
    protected static final int LED_ACTIVE = 14;
    protected static final int STICK = 0;
    protected static final int STICK_TOP = 3;
    protected static final int STICK_TOP_OVER = 11;
    protected static final int STICK_TOP_PRESS = 14;
    protected static final int STICK_TOP_DRAG = 15;
    protected static final int OUTERRING = 6;
    protected static final int ACTIONRING = 5;
    protected static final int BACK = 6;
    protected static final int ROD = 1;
    protected static final float RAD90 = PApplet.radians((float)90.0f);
    protected static final float RAD45 = PApplet.radians((float)45.0f);
    protected static final float RAD22_5 = PApplet.radians((float)22.5f);
    protected static final int[] posMap = new int[]{1, 7, 4, 28, 16, 112, 64, 193};
    protected static final int[] posX = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    protected static final int[] posY = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    protected final float ledWidth;
    protected final float ledHeight;
    protected float ledRingRad;
    protected float actionRad;
    protected float actionRadLimit;
    protected float gripRad;
    protected float rodRad;
    protected float rodLength = 0.0f;
    protected float stickAngle;
    protected int position = -1;
    protected int mode = 1;
    protected int status = 0;

    public GStick(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
        this.makeBuffer();
        if (this.width < 40.0f || this.height < 40.0f) {
            this.resize(PApplet.max((int)Math.round(this.width), (int)40), PApplet.max((int)Math.round(this.height), (int)40));
        }
        this.opaque = false;
        float f5 = PApplet.min((float)this.width, (float)this.height);
        float f6 = f5 / 50.0f;
        this.ledWidth = 6.0f * f6;
        this.ledHeight = 1.6f * this.ledWidth;
        this.ledRingRad = (f5 - this.ledWidth - 3.0f) / 2.0f;
        this.actionRad = 0.5f * this.ledRingRad;
        this.gripRad = 4.0f * f6;
        this.rodRad = 3.0f * f6;
        this.actionRadLimit = this.ledRingRad - this.gripRad - this.ledWidth / 2.0f;
        this.hotspots = new HotSpot[]{new HotSpot.HScircle(1, this.width / 2.0f, this.height / 2.0f, this.gripRad)};
        this.z = 24;
        this.createEventHandler(G4P.sketchWindow, "handleStickEvents", new Class[]{GStick.class, GEvent.class}, new String[]{"stick", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        G4P.registerControl(this);
    }

    public void setMode(int n) {
        if (n != this.mode && n == 1 || n == 2) {
            this.mode = n;
            this.bufferInvalid = true;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStickX() {
        return this.position < 0 ? 0 : posX[this.position];
    }

    public int getStickY() {
        return this.position < 0 ? 0 : posY[this.position];
    }

    protected float calcStickAngle(float f, float f2) {
        float f3 = PApplet.atan2((float)f2, (float)f);
        if (f3 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        return f3;
    }

    protected int getPositionFromAngle(float f) {
        int n;
        if (this.mode == 1) {
            f = (f + RAD45) % ((float)Math.PI * 2);
            n = 2 * (int)(f / RAD90);
        } else {
            f = (f + RAD22_5) % ((float)Math.PI * 2);
            n = (int)(f / RAD45);
        }
        return n % 8;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        this.ox -= this.width / 2.0f;
        this.oy -= this.height / 2.0f;
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot <= -1 || this.z <= this.focusObjectZ()) break;
                this.status = 2;
                this.position = -1;
                this.rodLength = PApplet.sqrt((float)(this.ox * this.ox + this.oy * this.oy));
                this.stickAngle = this.calcStickAngle(this.ox, this.oy);
                this.dragging = false;
                this.takeFocus();
                this.bufferInvalid = true;
                break;
            }
            case 2: {
                if (focusIsWith == this) {
                    this.loseFocus(this.parent);
                }
                if (this.position != -1) {
                    this.position = -1;
                    this.fireEvent(new Object[]{this, GEvent.CHANGED});
                }
                this.hotspots[0].adjust(Float.valueOf(this.width / 2.0f), Float.valueOf(this.height / 2.0f));
                this.stickAngle = 0.0f;
                this.rodLength = 0.0f;
                this.dragging = false;
                this.status = 0;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.status = 3;
                this.dragging = true;
                this.rodLength = PApplet.sqrt((float)(this.ox * this.ox + this.oy * this.oy));
                this.stickAngle = this.calcStickAngle(this.ox, this.oy);
                int n = -1;
                if (this.rodLength >= this.actionRad) {
                    n = this.getPositionFromAngle(this.stickAngle);
                }
                if (this.rodLength > this.actionRadLimit) {
                    this.ox = this.actionRadLimit * PApplet.cos((float)this.stickAngle);
                    this.oy = this.actionRadLimit * PApplet.sin((float)this.stickAngle);
                    this.rodLength = this.actionRadLimit;
                }
                this.hotspots[0].adjust(Float.valueOf(this.ox + this.width / 2.0f), Float.valueOf(this.oy + this.height / 2.0f));
                if (n != this.position) {
                    this.position = n;
                    this.fireEvent(new Object[]{this, GEvent.CHANGED});
                }
                this.bufferInvalid = true;
                break;
            }
            case 5: {
                int n = this.status;
                this.status = this.currSpot == 1 ? 1 : 0;
                if (n == this.status) break;
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            if (this.opaque) {
                this.buffer.background(this.palette[6].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.width / 2.0f, this.height / 2.0f);
            this.buffer.fill(this.palette[6].getRGB());
            this.buffer.stroke(this.palette[0].getRGB());
            this.buffer.strokeWeight(1.0f);
            this.buffer.ellipse(0.0f, 0.0f, 2.0f * this.ledRingRad, 2.0f * this.ledRingRad);
            this.buffer.ellipse(0.0f, 0.0f, 2.0f * this.actionRad, 2.0f * this.actionRad);
            this.buffer.pushMatrix();
            int n = 1;
            int n2 = 2 / this.mode;
            for (int i = 0; i < 8; i += n2) {
                this.buffer.stroke(this.palette[0].getRGB());
                this.buffer.strokeWeight(1.0f);
                this.buffer.line(0.0f, 0.0f, this.ledRingRad, 0.0f);
                if (i % 2 == 0) {
                    this.buffer.noStroke();
                    if (this.position >= 0 && (posMap[this.position] & n) == n) {
                        this.buffer.fill(this.palette[14].getRGB());
                    } else {
                        this.buffer.fill(this.palette[1].getRGB());
                    }
                    this.buffer.ellipse(this.ledRingRad, 0.0f, this.ledWidth, this.ledHeight);
                }
                n <<= n2;
                this.buffer.rotate((float)n2 * RAD45);
            }
            this.buffer.popMatrix();
            this.buffer.fill(this.palette[5].getRGB());
            this.buffer.stroke(this.palette[0].getRGB());
            this.buffer.strokeWeight(1.0f);
            this.buffer.ellipse(0.0f, 0.0f, 2.0f * this.actionRad, 2.0f * this.actionRad);
            this.buffer.pushMatrix();
            this.buffer.rotate(this.stickAngle);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[1].getRGB());
            this.buffer.ellipse(0.0f, 0.0f, 2.0f * this.rodRad, 2.0f * this.rodRad);
            this.buffer.rect(0.0f, -this.rodRad, this.rodLength, 2.0f * this.rodRad);
            this.buffer.strokeWeight(1.0f);
            this.buffer.stroke(this.palette[1].getRGB());
            switch (this.status) {
                case 0: {
                    this.buffer.fill(this.palette[3].getRGB());
                    break;
                }
                case 1: {
                    this.buffer.fill(this.palette[11].getRGB());
                    break;
                }
                case 2: {
                    this.buffer.fill(this.palette[14].getRGB());
                    break;
                }
                case 3: {
                    this.buffer.fill(this.palette[15].getRGB());
                }
            }
            this.buffer.ellipse(this.rodLength, 0.0f, 2.0f * this.gripRad, 2.0f * this.gripRad);
            this.buffer.popMatrix();
            this.buffer.endDraw();
        }
    }
}

