/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GAlign;
import g4p_controls.GButton;
import g4p_controls.GControlMode;
import g4p_controls.GEditableTextControl;
import g4p_controls.GEvent;
import g4p_controls.GIcon;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class GSpinner
extends GEditableTextControl {
    private static float MIN_BUTTON_WIDTH = 16.0f;
    private int low = -100;
    private int high = 100;
    private int value = 0;
    private int lastValue = 0;
    private int delta = 10;
    private GButton btnInc;
    private GButton btnDec;

    public GSpinner(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, MIN_BUTTON_WIDTH);
    }

    public GSpinner(PApplet pApplet, float f, float f2, float f3, float f4, float f5) {
        super(pApplet, f, f2, f3, f4);
        this.children = new LinkedList();
        this.ty = 2.0f;
        this.tx = 2.0f;
        f5 = Math.max(f5, MIN_BUTTON_WIDTH);
        this.tw = this.width - f5 - 4.0f;
        this.th = this.height - 4.0f;
        this.wrapWidth = Integer.MAX_VALUE;
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new HotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        G4P.pushStyle();
        G4P.showMessages = false;
        this.z = 0;
        G4P.control_mode = GControlMode.CORNER;
        int n = Math.round(f5);
        int n2 = Math.round(this.th / 2.0f);
        this.btnInc = new GButton(pApplet, 0.0f, 0.0f, f5, 1.0f + this.th / 2.0f);
        GIcon gIcon = this.makeSpinnerButtonIcon(pApplet, n, n2, true);
        this.btnInc.setIcon(gIcon, GAlign.NORTH, GAlign.CENTER, GAlign.CENTER);
        this.btnInc.addEventHandler(this, "handleInc");
        this.addControl(this.btnInc, this.tw + 2.0f, 1.0f, 0.0f);
        this.btnDec = new GButton(pApplet, 0.0f, 0.0f, f5, 1.0f + this.th / 2.0f);
        gIcon = this.makeSpinnerButtonIcon(pApplet, n, n2, false);
        this.btnDec.setIcon(gIcon, GAlign.NORTH, GAlign.CENTER, GAlign.CENTER);
        this.btnDec.addEventHandler(this, "handleDec");
        this.addControl(this.btnDec, this.tw + 2.0f, 1.0f + this.th / 2.0f, 0.0f);
        G4P.popStyle();
        this.setValue(0);
        this.createEventHandler(G4P.sketchWindow, "handleTextEvents", new Class[]{GEditableTextControl.class, GEvent.class}, new String[]{"textcontrol", "event"});
        this.registeredMethods = 15;
        this.localFont = G4P.inputFont;
        this.bufferInvalid = true;
        G4P.registerControl(this);
    }

    private GIcon makeSpinnerButtonIcon(PApplet pApplet, float f, float f2, boolean bl) {
        int[] nArray;
        int[] nArray2 = new int[]{3, 8, 12};
        if (bl) {
            int[] nArray3 = new int[3];
            nArray3[0] = 12;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 12;
        } else {
            int[] nArray4 = new int[3];
            nArray4[0] = 2;
            nArray4[1] = 12;
            nArray = nArray4;
            nArray4[2] = 2;
        }
        int[] nArray5 = nArray;
        PGraphics pGraphics = pApplet.createGraphics(16, 16, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.clear();
        pGraphics.noStroke();
        pGraphics.fill(0);
        pGraphics.beginShape();
        for (int i = 0; i < 3; ++i) {
            pGraphics.vertex((float)nArray2[i], (float)nArray5[i]);
        }
        pGraphics.endShape();
        pGraphics.endDraw();
        PImage pImage = pGraphics.get();
        pImage.resize(Math.round(f), Math.round(f2));
        return new GIcon(pApplet, pImage, 1, 1);
    }

    public void setLimits(int n, int n2, int n3, int n4) {
        this.low = Math.min(n2, n3);
        this.high = Math.max(n2, n3);
        n = PApplet.constrain((int)n, (int)n2, (int)n3);
        this.delta = n4 = Math.min(n4, n3 - n2);
        this.lastValue = n;
        this.setValue(n);
    }

    public void handleDec(GButton gButton, GEvent gEvent) {
        if (gEvent == GEvent.CLICKED && this.dec()) {
            this.fireEvent(new Object[]{this, GEvent.CHANGED});
        }
    }

    public void handleInc(GButton gButton, GEvent gEvent) {
        if (gEvent == GEvent.CLICKED && this.inc()) {
            this.fireEvent(new Object[]{this, GEvent.CHANGED});
        }
    }

    public boolean dec() {
        int n = PApplet.constrain((int)(this.value - this.delta), (int)this.low, (int)this.high);
        boolean bl = n != this.value;
        this.setValue(n);
        return bl;
    }

    public boolean inc() {
        int n = PApplet.constrain((int)(this.value + this.delta), (int)this.low, (int)this.high);
        boolean bl = n != this.value;
        this.setValue(n);
        return bl;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (this.value != (n = PApplet.constrain((int)n, (int)this.low, (int)this.high)) || this.stext.length() == 0) {
            this.lastValue = this.value;
            this.value = n;
            this.stext.setText("" + this.value, Integer.MAX_VALUE);
            this.bufferInvalid = true;
        }
    }

    @Override
    public void setStyledText(StyledString styledString) {
    }

    @Override
    public void setText(String string) {
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphics pGraphics = this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.image((PImage)this.buffer, 0.0f, 0.0f);
        pGraphics.endDraw();
        return pGraphics;
    }

    @Override
    public void pre() {
        if (this.keepCursorInView) {
            boolean bl = false;
            float f = this.caretX - this.tw + 2.0f;
            if (this.endTLHI != null) {
                if (this.ptx > this.caretX) {
                    this.ptx -= this.getScrollAmount();
                    if (this.ptx < 0.0f) {
                        this.ptx = 0.0f;
                    }
                    bl = true;
                } else if (this.ptx < f) {
                    this.ptx += this.getScrollAmount();
                    if (this.ptx > f) {
                        this.ptx = f;
                    }
                    bl = true;
                }
                if (this.ptx > 0.0f && this.endTLHI.tli.layout.getAdvance() - this.ptx < this.tw - 2.0f) {
                    this.ptx = Math.max(0.0f, this.endTLHI.tli.layout.getAdvance() - this.tw - 2.0f);
                    bl = true;
                }
            }
            if (bl) {
                this.bufferInvalid = true;
            } else {
                this.keepCursorInView = false;
            }
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.currSpot == 1) {
                    if (focusIsWith != this && this.z >= this.focusObjectZ()) {
                        this.keepCursorInView = true;
                        this.takeFocus();
                    }
                    this.dragging = false;
                    if (this.stext.getPlainText().equals("")) {
                        this.stext.setText(" ");
                    }
                    if (this.stext.getPlainText().equals(" ")) {
                        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
                        this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
                        this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
                        this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
                        int n = this.endTLHI.tli.layout.getCharacterCount();
                        this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
                    } else {
                        this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                        this.startTLHI = new StyledString.TextLayoutHitInfo(this.endTLHI);
                    }
                    this.calculateCaretPos(this.endTLHI);
                    this.bufferInvalid = true;
                    break;
                }
                if (focusIsWith != this) break;
                this.loseFocus(this.parent);
                break;
            }
            case 2: {
                this.dragging = false;
                this.bufferInvalid = true;
                break;
            }
            case 8: {
                boolean bl;
                int n;
                if (this.currSpot != 1) break;
                if (focusIsWith == this) {
                    this.loseFocus(this.parent);
                }
                if ((n = mouseEvent.getCount() * G4P.wheelForSpinner) == 0) break;
                boolean bl2 = bl = n > 0 ? this.inc() : this.dec();
                if (!bl) break;
                this.fireEvent(new Object[]{this, GEvent.CHANGED});
            }
        }
    }

    @Override
    protected void loseFocus(GAbstractControl gAbstractControl) {
        if (focusIsWith == this) {
            int n;
            int n2 = Integer.parseInt(this.stext.getPlainText());
            if (n2 != (n = PApplet.constrain((int)n2, (int)this.low, (int)this.high))) {
                super.setText("" + n);
                System.out.println(n2 + " >> " + n);
            }
            this.fireEvent(new Object[]{this, GEvent.LOST_FOCUS});
        }
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = gAbstractControl;
        this.keepCursorInView = true;
        this.bufferInvalid = true;
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (!(this.visible && this.enabled && this.textEditEnabled && this.available)) {
            return;
        }
        if (focusIsWith == this && this.endTLHI != null) {
            char c = keyEvent.getKey();
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getAction();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            this.textChanged = false;
            this.keepCursorInView = true;
            this.endChar = this.endTLHI.tli.startCharIndex + this.endTLHI.thi.getInsertionIndex();
            this.startChar = this.startTLHI != null ? this.startTLHI.tli.startCharIndex + this.startTLHI.thi.getInsertionIndex() : this.endChar;
            this.pos = this.endChar;
            this.nbr = 0;
            this.adjust = 0;
            if (this.endChar != this.startChar) {
                if (this.startChar < this.endChar) {
                    this.pos = this.startChar;
                    this.nbr = this.endChar - this.pos;
                } else if (this.startChar > this.endChar) {
                    this.pos = this.endChar;
                    this.nbr = this.startChar - this.pos;
                }
            }
            if (n2 == 1) {
                this.keyPressedProcess(n, c, bl, bl2);
            } else if (n2 == 3) {
                this.keyTypedProcess(n, c, bl, bl2);
            }
            if (this.textChanged) {
                this.changeText();
                this.fireEvent(new Object[]{this, GEvent.CHANGED});
            }
        }
    }

    @Override
    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
        this.ksm.logKey(1);
        switch (n) {
            case 37: {
                this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                this.moveCaretRight(this.endTLHI);
                break;
            }
            case 36: {
                this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                this.moveCaretEndOfLine(this.endTLHI);
            }
        }
        this.calculateCaretPos(this.endTLHI);
    }

    @Override
    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
        this.ksm.logKey(1);
        int n2 = "0123456789-".indexOf(c);
        if (n2 >= 0) {
            if (n2 < 10) {
                this.stext.insertCharacters("" + c, this.pos);
                this.adjust = 1;
                this.textChanged = true;
            } else {
                String string = this.stext.getPlainText();
                if (!string.startsWith("-")) {
                    this.stext.insertCharacters("-", 0);
                    this.adjust = 1;
                } else {
                    this.stext.deleteCharacters(0, 1);
                    this.adjust = 0;
                }
                this.textChanged = true;
            }
            int n3 = this.stext.getPlainText().startsWith("-") ? 1 : 0;
            System.out.println("Char at " + n3 + " = '" + this.stext.getPlainText().charAt(n3) + "'   Len = " + this.stext.length());
            while (this.stext.getPlainText().charAt(n3) == '0' && this.stext.length() > n3 + 1) {
                this.stext.deleteCharacters(n3, 1);
                --this.adjust;
                this.textChanged = true;
            }
        } else if (c == '\b') {
            if (this.stext.deleteCharacters(this.pos - 1, 1)) {
                this.adjust = -1;
                this.textChanged = true;
            }
        } else if (c == '\u007f') {
            if (this.stext.deleteCharacters(this.pos, 1)) {
                this.adjust = 0;
                this.textChanged = true;
            }
        } else if (c == '\n' || c == '\r') {
            this.fireEvent(new Object[]{this, GEvent.ENTERED});
            if (this.tabManager != null && this.tabManager.nextControl(this)) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        } else if (c == '\t' && this.tabManager != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? this.tabManager.prevControl(this) : this.tabManager.nextControl(this);
            if (bl3) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        }
        if (this.stext.length() == 0) {
            this.stext.insertCharacters("0", 0);
            ++this.adjust;
            this.textChanged = true;
        } else if (this.stext.getPlainText().equals("-")) {
            this.stext.insertCharacters("0", 1);
            ++this.adjust;
            this.textChanged = true;
        }
    }

    @Override
    protected boolean changeText() {
        if (!super.changeText()) {
            return false;
        }
        try {
            this.lastValue = this.value = Integer.parseInt(this.stext.getPlainText());
            this.startTLHI.copyFrom(this.endTLHI);
        }
        catch (NumberFormatException numberFormatException) {
            this.setValue(this.lastValue);
            this.loseFocus(this.parent);
        }
        return true;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (focusIsWith == this && this.showCaret && this.endTLHI.tli != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.5f);
                this.winApp.stroke(this.palette[12].getRGB());
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            boolean bl;
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            boolean bl2 = bl = this.promptText != null && !this.hasFocus() && (linkedList.isEmpty() || this.stext.getPlainText().equals("") || this.stext.getPlainText().equals(" "));
            if (bl) {
                linkedList = this.promptText.getLines(graphics2D);
            }
            if (this.opaque) {
                this.buffer.background(this.palette[6].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7].getRGB());
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            if (this.hasFocus() && this.stext.getPlainText().equals(" ")) {
                linkedList = this.stext.getLines(this.buffer.g2);
                this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
                this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
                this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
                int n = this.endTLHI.tli.layout.getCharacterCount();
                this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
            }
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                graphics2D.setColor(this.palette[2]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
        }
    }
}

