/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.Focusable;
import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GControlMode;
import g4p_controls.GEvent;
import g4p_controls.GTabManager;
import g4p_controls.GTimer;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public final class GPassword
extends GAbstractControl
implements Focusable {
    protected StyledString.TextLayoutHitInfo cursorTLHI = new StyledString.TextLayoutHitInfo();
    private static char cover = (char)35;
    private StyledString stext = new StyledString(" ");
    private StyledString hidden = new StyledString(" ");
    private int maxWordLength = 10;
    private int wordLength = 0;
    GTabManager tabManager = null;
    protected int wrapWidth = Integer.MAX_VALUE;
    protected float tx;
    protected float ty;
    protected float th;
    protected float tw;
    protected float ptx;
    protected float pty;
    protected float caretX;
    protected float caretY;
    protected boolean keepCursorInView = false;
    protected GeneralPath gpTextDisplayArea;
    protected StyledString.TextLayoutHitInfo startTLHI = new StyledString.TextLayoutHitInfo();
    protected StyledString.TextLayoutHitInfo endTLHI = new StyledString.TextLayoutHitInfo();
    protected GTimer caretFlasher;
    protected boolean showCaret = false;
    protected int endChar = -1;
    protected int startChar = -1;
    protected int pos = this.endChar;
    protected int nbr = 0;
    protected int adjust = 0;
    protected boolean textChanged = false;
    protected Font localFont = G4P.inputFont;

    public GPassword(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0);
    }

    public GPassword(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4);
        this.makeBuffer();
        this.caretFlasher = new GTimer(pApplet, this, "flashCaret", 400);
        this.caretFlasher.start();
        this.opaque = true;
        this.cursorOver = 2;
        this.setVisibleChar(cover);
        this.children = new LinkedList();
        this.ty = 2.0f;
        this.tx = 2.0f;
        this.tw = this.width - 4.0f;
        this.th = this.height;
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new HotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        G4P.showMessages = false;
        this.z = 0;
        G4P.control_mode = GControlMode.CORNER;
        this.createEventHandler(G4P.sketchWindow, "handlePasswordEvents", new Class[]{GPassword.class, GEvent.class}, new String[]{"pwordControl", "event"});
        this.registeredMethods = 15;
        this.localFont = G4P.inputFont;
        this.bufferInvalid = true;
        G4P.registerControl(this);
    }

    public void setVisibleChar(char c) {
        char c2 = c;
        if (c2 >= '!' && c2 <= '\u00ff' && c2 != '\u007f' || c2 == '\u20ac') {
            cover = c;
        }
    }

    public String getPassword() {
        String string = this.hidden.getPlainText();
        return string.equals(" ") ? "" : string;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    public void setMaxWordLength(int n) {
        if (this.wordLength == 0 && n >= 1) {
            this.maxWordLength = n;
        }
    }

    public void setFont(Font font) {
        if (font != null && font != this.localFont) {
            this.localFont = font;
            this.bufferInvalid = true;
        }
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphicsJava2D.beginDraw();
        pGraphicsJava2D.image((PImage)this.buffer, 0.0f, 0.0f);
        pGraphicsJava2D.endDraw();
        return pGraphicsJava2D;
    }

    @Override
    public void pre() {
        if (this.keepCursorInView) {
            boolean bl = false;
            float f = this.caretX - this.tw + 2.0f;
            if (this.endTLHI != null) {
                if (this.ptx > this.caretX) {
                    this.ptx -= (float)(this.localFont.getSize() / 3);
                    if (this.ptx < 0.0f) {
                        this.ptx = 0.0f;
                    }
                    bl = true;
                } else if (this.ptx < f) {
                    this.ptx += (float)this.localFont.getSize() / 1.5f;
                    if (this.ptx > f) {
                        this.ptx = f;
                    }
                    bl = true;
                }
                if (this.ptx > 0.0f && this.endTLHI.tli.layout.getAdvance() - this.ptx < this.tw - 2.0f) {
                    this.ptx = Math.max(0.0f, this.endTLHI.tli.layout.getAdvance() - this.tw - 2.0f);
                    bl = true;
                }
            }
            if (bl) {
                this.bufferInvalid = true;
            } else {
                this.keepCursorInView = false;
            }
        }
    }

    public void flashCaret(GTimer gTimer) {
        this.showCaret = !this.showCaret;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.currSpot == 1) {
                    if (focusIsWith != this && this.z >= this.focusObjectZ()) {
                        this.keepCursorInView = true;
                        this.takeFocus();
                    }
                    this.dragging = false;
                    if (this.stext == null || this.stext.length() == 0) {
                        this.stext = new StyledString(" ", this.wrapWidth);
                        this.stext.getLines(this.buffer.g2);
                    }
                    this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                    this.startTLHI = new StyledString.TextLayoutHitInfo(this.endTLHI);
                    this.calculateCaretPos(this.endTLHI);
                    this.bufferInvalid = true;
                    break;
                }
                if (focusIsWith != this) break;
                this.loseFocus(this.parent);
                break;
            }
            case 2: {
                this.dragging = false;
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        if (focusIsWith == this && this.endTLHI != null) {
            char c = keyEvent.getKey();
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getAction();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            this.textChanged = false;
            this.keepCursorInView = true;
            this.endChar = this.endTLHI.tli.startCharIndex + this.endTLHI.thi.getInsertionIndex();
            this.startChar = this.startTLHI != null ? this.startTLHI.tli.startCharIndex + this.startTLHI.thi.getInsertionIndex() : this.endChar;
            this.pos = this.endChar;
            this.nbr = 0;
            this.adjust = 0;
            if (this.endChar != this.startChar) {
                if (this.startChar < this.endChar) {
                    this.pos = this.startChar;
                    this.nbr = this.endChar - this.pos;
                } else if (this.startChar > this.endChar) {
                    this.pos = this.endChar;
                    this.nbr = this.startChar - this.pos;
                }
            }
            if (n2 == 1) {
                this.keyPressedProcess(n, c, bl, bl2);
            } else if (n2 == 3) {
                this.keyTypedProcess(n, c, bl, bl2);
            }
            if (this.textChanged) {
                this.changeText();
                this.fireEvent(new Object[]{this, GEvent.CHANGED});
            }
        }
    }

    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
        boolean bl3 = true;
        switch (n) {
            case 37: {
                this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                this.moveCaretRight(this.endTLHI);
                break;
            }
            case 36: {
                this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                this.moveCaretEndOfLine(this.endTLHI);
                break;
            }
            default: {
                bl3 = false;
            }
        }
        if (bl3) {
            this.calculateCaretPos(this.endTLHI);
            this.startTLHI.copyFrom(this.endTLHI);
        }
    }

    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
        char c2 = c;
        if (this.isDisplayable(c2) && this.wordLength < this.maxWordLength) {
            if (this.hidden.getPlainText().equals(" ")) {
                this.stext.setText("" + cover);
                this.hidden.setText("" + c);
            } else {
                this.stext.insertCharacters("" + cover, this.pos);
                this.hidden.insertCharacters("" + c, this.pos);
            }
            ++this.wordLength;
            this.adjust = 1;
            this.textChanged = true;
        } else if (c == '\b') {
            if (this.stext.deleteCharacters(this.pos - 1, 1)) {
                this.hidden.deleteCharacters(this.pos - 1, 1);
                this.wordLength = --this.wordLength < 0 ? 0 : this.wordLength;
                this.adjust = -1;
                this.textChanged = true;
            }
        } else if (c == '\u007f') {
            if (this.stext.deleteCharacters(this.pos, 1)) {
                this.hidden.deleteCharacters(this.pos, 1);
                --this.wordLength;
                this.adjust = 0;
                this.textChanged = true;
            }
        } else if (c == '\n' || c == '\r') {
            this.fireEvent(new Object[]{this, GEvent.ENTERED});
            if (this.tabManager != null && this.tabManager.nextControl(this)) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        } else if (c == '\t' && this.tabManager != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? this.tabManager.prevControl(this) : this.tabManager.nextControl(this);
            if (bl3) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        }
        if (this.stext.length() == 0) {
            this.stext.insertCharacters(" ", 0);
            this.hidden.insertCharacters(" ", 0);
            ++this.adjust;
            this.textChanged = true;
        }
    }

    protected boolean changeText() {
        TextHitInfo textHitInfo = null;
        TextHitInfo textHitInfo2 = null;
        this.pos += this.adjust;
        this.stext.getLines(this.buffer.g2);
        StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforCharNo(this.pos);
        if (textLayoutInfo == null) {
            this.endTLHI = null;
            this.startTLHI = null;
            this.pty = 0.0f;
            this.ptx = 0.0f;
            this.caretY = 0.0f;
            this.caretX = 0.0f;
            return false;
        }
        int n = this.pos - textLayoutInfo.startCharIndex;
        try {
            textHitInfo2 = textLayoutInfo.layout.getNextRightHit(n);
        }
        catch (Exception exception) {
            textHitInfo2 = null;
        }
        textHitInfo = n <= 0 ? textLayoutInfo.layout.getNextLeftHit(textHitInfo2) : (n >= textLayoutInfo.nbrChars ? textLayoutInfo.layout.getNextRightHit(textLayoutInfo.nbrChars - 1) : textLayoutInfo.layout.getNextLeftHit(textHitInfo2));
        this.endTLHI.setInfo(textLayoutInfo, textHitInfo);
        this.calculateCaretPos(this.endTLHI);
        this.bufferInvalid = true;
        this.startTLHI.copyFrom(this.endTLHI);
        return true;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (focusIsWith == this && this.showCaret && this.endTLHI.tli != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.9f);
                this.winApp.stroke(this.palette[12].getRGB());
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            if (this.opaque) {
                this.buffer.background(this.palette[6].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7].getRGB());
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                graphics2D.setColor(this.palette[2]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
        }
    }

    @Override
    protected void loseFocus(GAbstractControl gAbstractControl) {
        int n;
        if (focusIsWith == this) {
            this.fireEvent(new Object[]{this, GEvent.LOST_FOCUS});
        }
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = gAbstractControl;
        if (this.stext.length() > 0 && (n = this.stext.getPlainText().trim().length()) == 0) {
            this.stext.setText("", this.wrapWidth);
        }
        this.keepCursorInView = true;
        this.bufferInvalid = true;
    }

    @Override
    protected void takeFocus() {
        if (focusIsWith != this) {
            if (focusIsWith != null) {
                focusIsWith.loseFocus(this);
            }
            this.fireEvent(new Object[]{this, GEvent.GETS_FOCUS});
        }
        focusIsWith = this;
    }

    @Override
    public void setFocus(boolean bl) {
        if (!bl) {
            this.loseFocus(this.parent);
            return;
        }
        if (focusIsWith != this) {
            this.dragging = false;
            if (this.stext == null || this.stext.length() == 0) {
                this.stext.setText(" ", this.wrapWidth);
            }
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
            this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
            this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
            this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
            int n = this.endTLHI.tli.layout.getCharacterCount();
            this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
            this.startTLHI.copyFrom(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
            this.bufferInvalid = true;
        }
        this.keepCursorInView = true;
        this.takeFocus();
    }

    protected void calculateCaretPos(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        float[] fArray = textLayoutHitInfo.tli.layout.getCaretInfo(textLayoutHitInfo.thi);
        this.caretX = fArray[0];
        this.caretY = textLayoutHitInfo.tli.yPosInPara;
    }

    protected boolean moveCaretStartOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretLeft(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextLeftHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            return false;
        }
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretRight(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            return false;
        }
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    @Override
    public void setLocalColorScheme(int n) {
        super.setLocalColorScheme(n);
    }

    @Override
    public void setTabManager(GTabManager gTabManager) {
        this.tabManager = gTabManager;
    }
}

